definition module StdControlDef


//	********************************************************************************
//	Clean Standard Object I/O library, version 1.0.1
//	
//	StdControl contains the types to define the standard set of controls.
//	********************************************************************************


import	StdIOCommon
from	StdPicture	import	DrawFunction, Picture


::	RadioControl		ls ps
 =	RadioControl		[RadioControlItem *(ls,ps)] RowsOrColumns Index
												[ControlAttribute *(ls,ps)]
::	CheckControl		ls ps
 =	CheckControl		[CheckControlItem *(ls,ps)] RowsOrColumns
												[ControlAttribute *(ls,ps)]
::	PopUpControl		ls ps
 =	PopUpControl		[PopUpControlItem *(ls,ps)] Index
												[ControlAttribute *(ls,ps)]
::	SliderControl		ls ps
 =	SliderControl		Direction Length SliderState (SliderAction *(ls,ps))
 												[ControlAttribute *(ls,ps)]
::	TextControl			ls ps
 =	TextControl			TextLine                [ControlAttribute *(ls,ps)]
::	EditControl			ls ps
 =	EditControl			TextLine Width NrLines  [ControlAttribute *(ls,ps)]
::	ButtonControl		ls ps
 =	ButtonControl		TextLine                [ControlAttribute *(ls,ps)]
::	CustomButtonControl ls ps
 =	CustomButtonControl	Size Look               [ControlAttribute *(ls,ps)]
::	CustomControl		ls ps
 =	CustomControl		Size Look               [ControlAttribute *(ls,ps)]
::	CompoundControl		 c ls ps
 =	CompoundControl		(c ls ps)               [ControlAttribute *(ls,ps)]

::	TextLine				:==	String
::	NrLines					:==	Int
::	Width					:==	Int
::	Length					:==	Int
::	RowsOrColumns
	=	Rows	Int
	|	Columns	Int
::	RadioControlItem	ps	:==	(TextLine,			  IOFunction ps)
::	CheckControlItem	ps	:==	(TextLine, MarkState, IOFunction ps)
::	PopUpControlItem	ps	:==	(TextLine,			  IOFunction ps)
::	Look					:==	SelectState -> UpdateState -> [DrawFunction]
::	SliderAction		ps	:==	SliderMove  -> ps -> ps
::	SliderMove
	=	SliderIncSmall
	|	SliderDecSmall
	|	SliderIncLarge
	|	SliderDecLarge
	|	SliderThumb Int

::	ControlAttribute ps								// Default:
	=	ControlId			Id						// no id
	|	ControlPos			ItemPos					// (RightTo previous,zero)
	|	ControlSize			Size					// system derived/overruled
	|	ControlMinimumSize	Size					// zero
	|	ControlResize		ControlResizeFunction	// no resize
	|	ControlSelectState	SelectState				// control Able
	|	ControlHide									// initially visible
	|	ControlFunction		(IOFunction		ps)		// id
	|	ControlModsFunction	(ModsIOFunction ps)		// ControlFunction
	|	ControlMouse		MouseStateFilter SelectState (MouseFunction ps)
													// no mouse input/overruled
	|	ControlKeyboard		KeyboardStateFilter	SelectState (KeyboardFunction ps)
													// no keyboard input/overruled
//	For CompoundControls only:
	|	ControlItemSpace	Int Int					// system dependent
	|	ControlHMargin		Int Int					// system dependent
	|	ControlVMargin		Int Int					// system dependent
	|	ControlLook			Look					// control is transparant
	|	ControlViewDomain	ViewDomain				// {zero,max range}
	|	ControlOrigin		Point					// Left top of ViewDomain
	|	ControlHScroll		ScrollFunction			// no horizontal scrolling
	|	ControlVScroll		ScrollFunction			// no vertical   scrolling

::	ControlResizeFunction
	:==	Size ->										// current	control size
		Size ->										// old		window  size
		Size ->										// new		window  size
		Size										// new		control size
::	ScrollFunction
	:==	ViewFrame		->							// current	view
		SliderState		->							// current	state of scrollbar
		SliderMove		->							// action of the user
		Int											// new thumb value of scrollbar
::	ControlType
	:==	String
